/** Contains static methods for handling arrays whose base type 
    implements interface Comparable. All methods use method
    compareTo compare elements. Included are:<br><br>

       linearSearch,        linearSearch1<br>
       min,                  insertValue<br>
       partition,            medianOf3<br>
       merge,                binarySearch<br>
       equal,                selectionSort<br>
       insertionSort,        mergesort<br>
       quicksort */
public class Compares  {

   /** Return an index i that truthifies R:<br>
      (1) h &lt;= i &lt;= k<br>
      (2) x not in b[h..i-1]<br>
      (3) i = k  or  x = b[i]
      */
   public static int linearSearch(Comparable[] b, int h, int k, Comparable x) {
      int i= h;
      // {inv P:  h <= i <= k  and  x not in b[h..i-1]
      while (i != k  && b[i].compareTo(x) != 0)
         {i= i+1;}
      return i;
   }
   
   /** Return an index i that truthifies R:<br>
      (1) h &lt;= i &lt;= k<br>
      (2) x not in b[h..i-1]<br>
      (3) i = k  or  x = b[i]
      */
   public static int linearSearch1(Comparable[] b, int h, int k, Comparable x) {
      // {inv P:  h <= i <= k  and  x not in b[h..i-1]}
      for (int i= h; i != k; i++) {
         if (b[i].compareTo(x) == 0)
            {return i;}
      }
      return k;
   }

   /** = a copy of array segment b[h..k] */
   public static Comparable[] copy(Comparable[] b, int h, int k) {
      Comparable[] c= new Comparable[k+1-h];
      // inv: b[h..i-1] has been copied to c[0..i-h-1]
      for (int i= h; i != k+1; i++) 
         {c[i-h]= b[i];}
      return c;
   }
    
   /** Given h <= k, return the position of the minimum value of b[h..k] */
   public static int min(Comparable[] b, int h, int k) {
      int p= h; // will contain index of minimum
      // {inv: b[p] is the minimum of b[h..i-1]}
      for (int i= h+1; i< k; i++) {
         if (b[i].compareTo(b[p]) < 0)
            {p= i;}
      }
      return p;
   }
   
   /** b[h..k-1] is sorted, and b[k] contains a value.
       Sort b[h..k] */
   public static void insertValue(Comparable[] b, int h, int k) {
      Comparable v= b[k];
      int i= k;
      /* inv P: (1) Placing v in b[i] makes b[h..k] a
                    permutation of its initial value
                (2) b[h..k] with b[i] removed is initial b[h..k-1]
                (3) v < b[i+1..k]
                */
      while ((i != h) && v.compareTo(b[i-1]) < 0) {
         b[i]= b[i-1];
         i= i-1;
      }
      b[i]= v;
   }
   
   /** b[h..k] has at least three elements. Let x be 
       the value initially in b[h]. Permute b[h..k]
       and return integer j satisfying R:<br><br>
    
         b[h..j-1] <= b[j] = x <= b[j+1..k]
      */
   public static int partition(Comparable[] b, int h, int k) {
      // {Q: Let x be the value initially in b[h]}
      int j;
      // Truthify R1: b[h+1..j] <= b[h] = x <= b[j+1..k];
         int i= h+1; j= k;
         // {inv P: b[h+1..i-1] <= b[h] = x <= b[j+1..k]}
         while (i <= j) {
            if (b[i].compareTo(b[h]) <= 0) i= i+1;
            else if (b[j].compareTo(b[h]) >= 0) j= j-1;
            else {// {b[j] < x < b[i]}
               Comparable t1= b[i]; b[i]= b[j]; b[j]= t1;
               i= i+1; j= j-1;
            }
          }
      Comparable t= b[h]; b[h]= b[j]; b[j]= t;
      // {R}
      return j;
   }
   
   //Permute b[h], b[(h+k)/2], and b[k] to put their median in b[h]
   public static void medianOf3(Comparable[] b, int h, int k) {
      int e= (h+k)/2;  // index of middle element of array
      int m;           // index of median
      // Return if b[h] is median; else store index of median in m
         if (b[h].compareTo(b[e]) <= 0) {
            if (b[h].compareTo(b[k]) >= 0) return;
            // {b[h] is smallest of the three}
            if (b[e].compareTo(b[k]) <= 0) m= e;
            else m= k;
         }
         else {
            if (b[h].compareTo(b[k]) <= 0) return;
            // {b[h] is largest of the three}
            if (b[e].compareTo(b[k]) <= 0) m= k;
            else m= e;
         }
      Comparable t= b[h]; b[h]= b[m]; b[m]= t;
   }
   
   /* Segments b[h..e] and b[e+1..k] are already sorted.
      Permute their values so that b[h..k] is sorted.
      */
   public static void merge (Comparable b[], int h, int e, int k) {
      Comparable[] c= copy(b,h,e);
      // {c is a copy of original b[h..e]}
      int i= h; int j= e+1; int m= 0;
      /* inv: b[h..i-1] contains its final, sorted values
         b[j..k] remains to be transferred
         c[m..e-h] remains to be transferred
         */
      for (i= h; i != k+1; i++) {
         if (j <= k && (m > e-h || b[j].compareTo(c[m]) <= 0))
            {b[i]= b[j]; j= j+1;}
         else
            {b[i]= c[m]; m= m+1;}
      }
   }
   
   /** Return a value i that satisfies R: b[i] <= x < b[i+1].
       Assume virtual elements b[-1] = -infinity and
       b.[b.length] = +infinity. */
   public static int binarySearch(int[] b, int x) {
      int i= -1; int j= b.length;
      // {P:b[i] <= x < b[j] and -1 <= i < j <= b.length}
      while (j != i+1) {
         int e= (i+j)/2;
         // {-1 <= i < e < j <= b.length}
         if (b[e] <= x) i= e;
         else j= e;
      }
      return i;
   }
   
   /** = "arrays b and c are equal" */
   public static boolean equal(Comparable[] b, Comparable[] c) {
      if (b == c) return true;
      if (b == null || c == null) return false;
      if (b.length != c.length) return false;
      // Return false if b[i] != c[i] for some i
         // inv: 0 <= i <= b.length  and  b[0..i-1] = c[0..i-1]
         for (int i= 0;  i != b.length; i++) {
            if (b[i].compareTo(c[i]) != 0) return false;
         }
      return true;
   }

   
   // Sort b --put its elements in ascending order
   public static void selectionSort(Comparable[] b) {
      int j= 0;
      // {inv P: b[0..j-1] is sorted and b[0..j-1] <= b[j..]}
      while (j != b.length) {
         int p= min(b, j, b.length-1);
         // {b[p] is minimum of b[j..b.length-1]}
         // Swap b[j] and b[p]
            Comparable t= b[j]; b[j]= b[p]; b[p]= t;
         j= j+1;
      }
   }
   
   /** Sort b --put its elements in ascending order */
   public static void selectionSort1(Comparable[] b) {
      int j= 0;
      // {inv P: b[0..j-1] is sorted and b[0..j-1] <= b[j..]}
      while (j != b.length) {
         // Put into p the index of smallest element in b[j..]
            int p= j; 
            for (int i= j+1; i != b.length; i++) {
               if (b[i].compareTo(b[p]) < 0)  p= i;
            }
         // Swap b[j] and b[p]
            Comparable t= b[j]; b[j]= b[p]; b[p]= t;
         j= j+1;
      }
   }
   
   /** Sort b[h..k] --put its elements in ascending order */
   public static void insertionSort(Comparable[] b, int h, int k) {
   // inv: h <= j <= k+1  and  b[h..j-1] is sorted
      for (int j= h; j <= k; j++) {
         // Sort b[0..j], given that b[0..j-1] is sorted
            insertValue(b,0,j);
      }
   }
   
   /** Sort b[h..k] */
   public static void mergesort(Comparable[] b, int h, int k) {
      if (h >= k) return;
      int e= (h+k)/2;
      mergesort(b, h, e);   // Sort b[h..e]
      mergesort(b, e+1, k); // Sort b[e+1:k]
      merge(b, h, e, k);    // Merge the 2 segments
   }
   
   /** Sort b[h..k] */
   public static void quicksort(Comparable[] b, int h, int k) {
      tailRecursionLoop: while(true) {
         if (k+1-h < 10) {
            insertionSort(b,h,k);
            return;
         }
         medianOf3(b,h,k);
         // {b[h] is between b[(j+k/2)] and b[k]}
         int j= partition(b,h,k);
         // b[h..j-1] <= b[j] <= b[j+1..k]
         if (j-h <= k-j) {
            quicksort(b,h,j-1);
            // quicksort(b,j+1,k);
               h= j+1;
               continue tailRecursionLoop;
         }
         else {
            quicksort(b,j+1,k);
            // quicksort(b,h,j-1);
               k= j-1;
               continue tailRecursionLoop;
         }
      } // tailRecursionLoop
   }

   
}
